#include <string>
#include <cstdio>
#include <zlib.h>
#include <sys/stat.h>
#include <stdlib.h>
//#include <filesystem>

//namespace fs = std::filesystem;

#include "target.h"

#define GZSUFFIX ".gz"

Target::Target(std::string const &filename,std::string const &dest,bool compressed,bool noGZ) {
  isCompressed = compressed;
  isOpen = false;
  path = makeFilePath(filename,dest,compressed && !noGZ);
}

bool Target::open(void) {
  if (isOpen) {
    return true;
  }
  bool okay;
  if (isCompressed) {
    fdGZ = gzopen(path.c_str(),"wb");
    okay = fdGZ != NULL;
  } else {
    fdUC = fopen(path.c_str(),"w");
    okay = fdUC != NULL;
  }
  if (okay) {
    isOpen = true;
  }
  return okay;
}

void Target::close(void) {
  if (isOpen) {
    if (isCompressed) {
      gzclose(fdGZ);
    } else {
      fsync(fileno(fdUC));
      fclose(fdUC);
    }
  }
  isOpen = false;
}

Target::~Target(void) {
  close();
}

void Target::write(char *buffer) {
  if (isCompressed) {
    gzprintf(fdGZ,"%s",buffer);
  } else {
    fprintf(fdUC,"%s",buffer);
  }
}

bool destOK(std::string const &bpath) {
//    fs::path p = bpath;
//    p.remove_filename();
    bool okay = false;
    std::size_t slash = bpath.find_last_of('/');
    if (slash == std::string::npos) { // no slash in the path, so just a filename
      okay = true;
    } else {
      struct stat dirinf;
      std::string bdir = bpath.substr(0,slash);
      int statres = stat(bdir.c_str(),&dirinf);
      if (statres || ((dirinf.st_mode & S_IFMT) != S_IFDIR)) {
        fprintf(stderr,"Unmatched reads output '%s': Destination dir '%s' not found or not a directory.  Quitting.\n", bpath.c_str(), bdir.c_str());
      } else {
        okay = true;
      }
    }
    return okay;
}

std::string Target::makeFilePath(std::string const &base,std::string const &dest,bool wantgz) {
  bool realdest,absolute,hasgz;
  std::string path,suff;
  unsigned suffixLength = strlen(GZSUFFIX);

  realdest = dest != ".";
  absolute = base[0] == '/';
  
  hasgz = base.size() >= suffixLength
          && base.substr(base.size()-suffixLength) == GZSUFFIX;
  wantgz = wantgz && !hasgz;
  suff = wantgz ? GZSUFFIX : "";
  if (absolute) {
    path = base + suff;
  } else {
    if (realdest) {
      path = dest + "/" + base + suff;
    } else {
      path = base + suff;
    }
  }
  if (!destOK(path)) {
    exit(-1);
  }
  return path;
}

